/*
Copyright 2008-2009 Elöd Egyed-Zsigmond, Cyril Laitang
Copyright 2009-2011 Samuel Gesche

This file is part of IPRI News Analyzer.

IPRI News Analyzer is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

IPRI News Analyzer is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with IPRI News Analyzer.  If not, see <http://www.gnu.org/licenses/>.
*/

package ihm.iprinewsanalyzer;

import javax.swing.BorderFactory;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;

import javax.swing.border.Border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Toolkit;

import java.util.Arrays;
import java.util.Hashtable;

public class Charte {

    static private int TAILLE_POLICE = 12;
    static{
        if(Toolkit.getDefaultToolkit().getScreenSize().width<=800){
            TAILLE_POLICE = 10;
        } else if(Toolkit.getDefaultToolkit().getScreenSize().width<=1024){
            TAILLE_POLICE = 11;
        }
    }
    final static private Font policeNorm = new Font("Times New Roman", 0, TAILLE_POLICE);
    final static private Color couleurEcriture = new Color(0x00, 0x40, 0x00);
    final static private Color couleurFond = new Color(0xF0, 0xFF, 0xF0);
    final static private Color couleurSelection = new Color(0xA0, 0xFF, 0xA0);
    final static private Border bordure = 
            BorderFactory.createEtchedBorder(new Color(0xA0, 0xFF, 0xA0), new Color(0xE0, 0xFF, 0xE0));
    final static private Border bordureBouton =
            BorderFactory.createEtchedBorder(new Color(0x00, 0xFF, 0x00), new Color(0xE0, 0xFF, 0xE0));
    /*BorderFactory.createBevelBorder(
            0, new Color(0xA0, 0xFF, 0xA0), new Color(0xB0, 0xFF, 0xB0),
            new Color(0xA0, 0xFF, 0xA0), new Color(0xB0, 0xFF, 0xB0));*/

    public static Color getForeground(){
        return couleurEcriture;
    }
    public static Color getSelectionBackground(){
        return couleurSelection;
    }
    public static Color getBackground(){
        return couleurFond;
    }
    public static Border getBorder(){
        return bordure;
    }

    public static void formateAndFormateChildren(Component c){
        formate(c);
        if (c instanceof Container) {
            Container c2 = (Container)c;
            for(int i=0; i<c2.getComponentCount(); i++){
                formateAndFormateChildren(c2.getComponent(i));
            }
        }
    }

    public static void formate(Component c){
        c.setForeground(couleurEcriture);
        c.setBackground(couleurFond);
        c.setFont(policeNorm);
    }
    /**
     * Initialise les paramètres généraux de l'IHM. Cette méthode doit être
     * appelée au démarrage de l'application, avant de créer le moindre
     * composant.
     * @since 3.0.1
     */
    public static void initUI() {
        String OK = "D'accord";
        String CANCEL = "Laisse tomber";
        String OUI = "Oui";
        String NON = "Non";

        ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
        UIManager.put("TabbedPane.tabsOpaque", Boolean.FALSE);
        UIManager.put("TabbedPane.contentOpaque", Boolean.FALSE);
        UIManager.put("OptionPane.yesButtonText", OUI);
        UIManager.put("OptionPane.noButtonText", NON);
        UIManager.put("OptionPane.okButtonText", OK);
        UIManager.put("OptionPane.cancelButtonText", CANCEL);
        UIManager.put("ProgressBar.cycleTime", new Integer(2000));

        UIManager.put("ToolTip.foreground", couleurEcriture);
        UIManager.put("OptionPane.foreground", couleurEcriture);
        UIManager.put("TextArea.foreground", couleurEcriture);
        UIManager.put("OptionPane.messageForeground", couleurEcriture);
        UIManager.put("Button.foreground", couleurEcriture);
        UIManager.put("ToggleButton.foreground", couleurEcriture);
        UIManager.put("EditorPane.foreground", couleurEcriture);
        UIManager.put("TextPane.foreground", couleurEcriture);
        UIManager.put("Panel.foreground", couleurEcriture);
        UIManager.put("Label.foreground", couleurEcriture);
        UIManager.put("FormattedTextField.foreground", couleurEcriture);
        UIManager.put("TextField.foreground", couleurEcriture);
        UIManager.put("ScrollBar.foreground", couleurEcriture);
        UIManager.put("ScrollPane.foreground", couleurEcriture);
        UIManager.put("ComboBox.foreground", couleurEcriture);
        UIManager.put("Tree.foreground", couleurEcriture);
        UIManager.put("Tree.textForeground", couleurEcriture);
        UIManager.put("Table.foreground", couleurEcriture);
        UIManager.put("TableHeader.foreground", couleurEcriture);
        UIManager.put("List.foreground", couleurEcriture);
        UIManager.put("TitledBorder.titleColor", couleurEcriture);
        UIManager.put("TabbedPane.foreground", couleurEcriture);
        UIManager.put("RadioButton.foreground", couleurEcriture);
        UIManager.put("ProgressBar.foreground", couleurEcriture);
        UIManager.put("ComboBox.disabledForeground", couleurEcriture);
        UIManager.put("ComboBox.selectionForeground", couleurEcriture);
        UIManager.put("Label.disabledForeground", couleurEcriture);
        UIManager.put("List.selectionForeground", couleurEcriture);
        UIManager.put("OptionPane.messageForeground", couleurEcriture);
        UIManager.put("ProgressBar.selectionForeground", couleurEcriture);
        UIManager.put("Tree.focusCellForeground", couleurEcriture);
        UIManager.put("Tree.selectionForeground", couleurEcriture);
        UIManager.put("Table.focusCellForeground", couleurEcriture);
        UIManager.put("Table.selectionForeground", couleurEcriture);
        UIManager.put("FormattedTextField.caretForeground", couleurEcriture);
        UIManager.put("FormattedTextField.inactiveForeground", couleurEcriture.darker());
        UIManager.put("FormattedTextField.selectionForeground", couleurEcriture);
        UIManager.put("TextField.caretForeground", couleurEcriture);
        UIManager.put("TextField.inactiveForeground", couleurEcriture.darker());
        UIManager.put("TextField.selectionForeground", couleurEcriture);
        UIManager.put("EditorPane.caretForeground", couleurEcriture);
        UIManager.put("EditorPane.inactiveForeground", couleurEcriture.darker());
        UIManager.put("EditorPane.selectionForeground", couleurEcriture);
        UIManager.put("TextPane.caretForeground", couleurEcriture);
        UIManager.put("TextPane.inactiveForeground", couleurEcriture.darker());
        UIManager.put("TextPane.selectionForeground", couleurEcriture);

        UIManager.put("ProgressBar.foreground", couleurFond.darker());

        UIManager.put("TabbedPane.focus", couleurFond);
        UIManager.put("ToolTip.background", couleurFond);
        UIManager.put("OptionPane.background", couleurFond);
        UIManager.put("Button.background", couleurFond);
        UIManager.put("Button.focus", couleurFond);
        UIManager.put("ToggleButton.background", couleurFond);
        UIManager.put("ToggleButton.focus", couleurFond);
        UIManager.put("TextArea.background", couleurFond);
        UIManager.put("Panel.background", couleurFond);
        UIManager.put("Label.background", couleurFond);
        UIManager.put("FormattedTextField.background", couleurFond);
        UIManager.put("TextField.background", couleurFond);
        UIManager.put("TextArea.background", couleurFond);
        UIManager.put("ScrollBar.background", couleurFond);
        UIManager.put("ScrollPane.background", couleurFond);
        UIManager.put("ComboBox.background", couleurFond);
        UIManager.put("ComboBox.buttonBackground", couleurFond);
        UIManager.put("ComboBox.buttonHighlight", couleurFond);
        UIManager.put("ComboBox.buttonShadow", couleurFond);
        UIManager.put("ComboBox.buttonDarkShadow", couleurFond);
        UIManager.put("Tree.background", couleurFond);
        UIManager.put("Tree.textBackground", couleurFond);
        UIManager.put("Table.background", couleurFond);
        UIManager.put("TableHeader.background", couleurFond);
        UIManager.put("ProgressBar.background", couleurFond);
        UIManager.put("EditorPane.background", couleurFond);
        UIManager.put("TextPane.background", couleurFond);
        UIManager.put("List.background", couleurFond);
        UIManager.put("Slider.background", couleurFond);
        UIManager.put("RadioButton.background", couleurFond);
        UIManager.put("TabbedPane.selected", couleurSelection);
        UIManager.put("List.selectionBackground", couleurSelection);
        UIManager.put("ComboBox.selectionBackground", couleurSelection);
        UIManager.put("ProgressBar.selectionBackground", couleurSelection);
        UIManager.put("Tree.selectionBackground", couleurSelection);
        UIManager.put("Table.selectionBackground", couleurSelection);
        UIManager.put("FormattedTextField.selectionBackground", couleurSelection);
        UIManager.put("TextField.selectionBackground", couleurSelection);
        UIManager.put("TextArea.selectionBackground", couleurSelection);
        UIManager.put("Button.select", couleurSelection);
        UIManager.put("ToggleButton.select", couleurSelection);
        UIManager.put("Table.focusCellBackground", couleurSelection);

        UIManager.put("ToolTip.font", policeNorm);
        UIManager.put("OptionPane.font", policeNorm);
        UIManager.put("OptionPane.messageFont", policeNorm);
        UIManager.put("OptionPane.buttonFont", policeNorm);
        UIManager.put("Button.font", policeNorm);
        UIManager.put("ToggleButton.font", policeNorm);
        UIManager.put("ScrollPane.font", policeNorm);
        UIManager.put("ComboBox.font", policeNorm);
        UIManager.put("Label.font", policeNorm);
        UIManager.put("FormattedTextField.font", policeNorm);
        UIManager.put("TextField.font", policeNorm);
        UIManager.put("TextArea.font", policeNorm);
        UIManager.put("Tree.font", policeNorm);
        UIManager.put("Table.font", policeNorm);
        UIManager.put("TitledBorder.font", policeNorm);
        UIManager.put("TableHeader.font", policeNorm);
        UIManager.put("ProgressBar.font", policeNorm);
        UIManager.put("List.font", policeNorm);
        UIManager.put("EditorPane.font", policeNorm);
        UIManager.put("RadioButton.font", policeNorm);
        UIManager.put("TabbedPane.font", policeNorm);

        UIManager.put("ToolTip.border", bordure);
        UIManager.put("Button.border", bordureBouton);
        UIManager.put("ToggleButton.border", bordureBouton);
        UIManager.put("TableHeader.cellBorder", bordure);
        UIManager.put("SplitPaneDivider.border", bordure);
        UIManager.put("ProgressBar.border", bordure);
        UIManager.put("FormattedTextField.border", bordure);
        UIManager.put("TextField.border", bordure);
        UIManager.put("TitledBorder.border", bordure);
        UIManager.put("TextArea.border", bordure);
        UIManager.put("EditorPane.border", bordure);
        UIManager.put("TextPane.border", bordure);
        UIManager.put("RadioButton.border", bordure);
        UIManager.put("ScrollPane.border",
                      BorderFactory.createEmptyBorder());
        UIManager.put("List.focusCellHighlightBorder",
                      BorderFactory.createEmptyBorder());
        UIManager.put("Tree.focusCellHighlightBorder",
                      BorderFactory.createEmptyBorder());
        UIManager.put("Table.focusCellHighlightBorder",
                      BorderFactory.createEmptyBorder());
        /*Hashtable h = UIManager.getLookAndFeelDefaults();
        Object[] s = new Object[h.keySet().size()];
        h.keySet().toArray(s);
        //Arrays.sort(s);
        for (int i = 0; i < s.length; i++) {
            if(s[i].toString().startsWith("Button"))
            System.out.println(s[i] + " = " + h.get(s[i]));
        }*/
    }

}